<?xml version="1.0"?>

<!--

# Project         : NeoDoc
# Module          : GnuCash
# File            : gnumeric.xsl
# Author          : Camille Bégnis
# Created On      : 2005-07-01
# Copyright       : Camille Bégnis <camille@neodoc.biz>,
#                    NeoDoc under the GPL license


This stylesheets takes a gnucash XML file (uncompressed) and outputs a
gnumeric compatible calc sheet.

Warning: For the transformation to work, the namespaces below
must be added to the gnucash root element.

-->


<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gmr="http://www.gnumeric.org/v10.dtd"
  xmlns:cd="cd" xmlns:gnc="gnc" xmlns:book="book" xmlns:slot="slot"
  xmlns:cmdty="cmdty" xmlns:price="price" xmlns:ts="ts" xmlns:act="act"
  xmlns:lot="lot" xmlns:trn="trn" xmlns:split="split" xmlns:sx="sx"
  xmlns:fs="fs" xmlns:cust="cust" xmlns:addr="addr" xmlns:job="job"
  xmlns:taxtable="taxtable" xmlns:tte="tte" xmlns:owner="owner"
  xmlns:invoice="invoice" xmlns:entry="entry" xmlns:vendor="vendor">

  <xsl:output indent="yes"/>
  <xsl:key name="accounts" match="gnc:account" use="act:id"/>

  <xsl:template match="/"><gmr:Workbook xmlns:gmr="http://www.gnumeric.org/v10.dtd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.gnumeric.org/v8.xsd">
  <gmr:Version Epoch="1" Major="4" Minor="2" Full="1.4.2"/>
  <gmr:Attributes>
    <gmr:Attribute>
      <gmr:type>4</gmr:type>
      <gmr:name>WorkbookView::show_horizontal_scrollbar</gmr:name>
      <gmr:value>TRUE</gmr:value>
    </gmr:Attribute>
    <gmr:Attribute>
      <gmr:type>4</gmr:type>
      <gmr:name>WorkbookView::show_vertical_scrollbar</gmr:name>
      <gmr:value>TRUE</gmr:value>
    </gmr:Attribute>
    <gmr:Attribute>
      <gmr:type>4</gmr:type>
      <gmr:name>WorkbookView::show_notebook_tabs</gmr:name>
      <gmr:value>TRUE</gmr:value>
    </gmr:Attribute>
    <gmr:Attribute>
      <gmr:type>4</gmr:type>
      <gmr:name>WorkbookView::do_auto_completion</gmr:name>
      <gmr:value>TRUE</gmr:value>
    </gmr:Attribute>
    <gmr:Attribute>
      <gmr:type>4</gmr:type>
      <gmr:name>WorkbookView::is_protected</gmr:name>
      <gmr:value>FALSE</gmr:value>
    </gmr:Attribute>
  </gmr:Attributes>
  <gmr:Summary>
    <gmr:Item>
      <gmr:name>application</gmr:name>
      <gmr:val-string>gnumeric</gmr:val-string>
    </gmr:Item>
    <gmr:Item>
      <gmr:name>application</gmr:name>
      <gmr:val-string>gnumeric</gmr:val-string>
    </gmr:Item>
  </gmr:Summary>
  <gmr:SheetNameIndex>
    <gmr:SheetName>Accounts</gmr:SheetName>
    <gmr:SheetName>Feuille2</gmr:SheetName>
    <gmr:SheetName>Feuille3</gmr:SheetName>
  </gmr:SheetNameIndex>
  <gmr:Geometry Width="768" Height="403"/>
  <gmr:Sheets>

    <gmr:Sheet DisplayFormulas="0" HideZero="0" HideGrid="0" HideColHeader="0" HideRowHeader="0" DisplayOutlines="1" OutlineSymbolsBelow="1" OutlineSymbolsRight="1">
      <gmr:Name>Accounts</gmr:Name>
      <gmr:MaxCol>-1</gmr:MaxCol>
      <gmr:MaxRow>-1</gmr:MaxRow>
      <gmr:Zoom>1</gmr:Zoom>
      <gmr:PrintInformation>
        <gmr:Margins>
          <gmr:top Points="120" PrefUnit="cm"/>
          <gmr:bottom Points="120" PrefUnit="cm"/>
          <gmr:left Points="0.000000" PrefUnit="Pt"/>
          <gmr:right Points="0.000000" PrefUnit="Pt"/>
          <gmr:header Points="0.000000" PrefUnit="Pt"/>
          <gmr:footer Points="0.000000" PrefUnit="Pt"/>
        </gmr:Margins>
        <gmr:Scale type="percentage" percentage="100"/>
        <gmr:vcenter value="0"/>
        <gmr:hcenter value="0"/>
        <gmr:grid value="0"/>
        <gmr:even_if_only_styles value="0"/>
        <gmr:monochrome value="0"/>
        <gmr:draft value="0"/>
        <gmr:titles value="0"/>
        <gmr:order>d_then_r</gmr:order>
        <gmr:orientation>portrait</gmr:orientation>
        <gmr:Header Left="" Middle="&amp;[TAB]" Right=""/>
        <gmr:Footer Left="" Middle="Page &amp;[PAGE]" Right=""/>
      </gmr:PrintInformation>
      <gmr:Styles>
        <gmr:StyleRegion startCol="0" startRow="0" endCol="255" endRow="65535">
          <gmr:Style HAlign="1" VAlign="2" WrapText="0" ShrinkToFit="0" Rotation="0" Shade="0" Indent="0" Locked="1" Hidden="0" Fore="0:0:0" Back="FFFF:FFFF:FFFF" PatternColor="0:0:0" Format="General">
            <gmr:Font Unit="10" Bold="0" Italic="0" Underline="0" StrikeThrough="0">Sans</gmr:Font>
            <gmr:StyleBorder>
              <gmr:Top Style="0"/>
              <gmr:Bottom Style="0"/>
              <gmr:Left Style="0"/>
              <gmr:Right Style="0"/>
              <gmr:Diagonal Style="0"/>
              <gmr:Rev-Diagonal Style="0"/>
            </gmr:StyleBorder>
          </gmr:Style>
        </gmr:StyleRegion>
      </gmr:Styles>
      <gmr:Cols DefaultSizePts="48"/>
      <gmr:Rows DefaultSizePts="12.75"/>
      <gmr:Selections CursorCol="0" CursorRow="0">
        <gmr:Selection startCol="0" startRow="0" endCol="0" endRow="0"/>
      </gmr:Selections>
      <gmr:Cells>
        <gmr:Cell Col="0" ValueType="60" Row="0">Name</gmr:Cell>
        <gmr:Cell Col="1" ValueType="60" Row="0">Type</gmr:Cell>
        <gmr:Cell Col="2" ValueType="60" Row="0">Code</gmr:Cell>
        <gmr:Cell Col="3" ValueType="60" Row="0">Quantity</gmr:Cell>
        <gmr:Cell Col="4" ValueType="60" Row="0">Currency</gmr:Cell>
        <gmr:Cell Col="5" ValueType="60" Row="0">Value</gmr:Cell>
        <xsl:apply-templates select="/gnc-v2/gnc:book/gnc:account"/>
      </gmr:Cells>
      <gmr:SheetLayout TopLeft="A1"/>
      <gmr:Solver ProblemType="1" Inputs="" MaxTime="0" MaxIter="0" NonNeg="1" Discr="0" AutoScale="0" ShowIter="0" AnswerR="0" SensitivityR="0" LimitsR="0" PerformR="0" ProgramR="0"/>
    </gmr:Sheet>


      <gmr:Sheet DisplayFormulas="0" HideZero="0" HideGrid="0" HideColHeader="0" HideRowHeader="0" DisplayOutlines="1" OutlineSymbolsBelow="1" OutlineSymbolsRight="1">
        <gmr:Name>Transactions</gmr:Name>
        <gmr:MaxCol>-1</gmr:MaxCol>
        <gmr:MaxRow>-1</gmr:MaxRow>
        <gmr:Zoom>1</gmr:Zoom>
        <gmr:PrintInformation>
          <gmr:Margins>
            <gmr:top Points="120" PrefUnit="cm"/>
            <gmr:bottom Points="120" PrefUnit="cm"/>
            <gmr:left Points="0.000000" PrefUnit="Pt"/>
            <gmr:right Points="0.000000" PrefUnit="Pt"/>
            <gmr:header Points="0.000000" PrefUnit="Pt"/>
            <gmr:footer Points="0.000000" PrefUnit="Pt"/>
          </gmr:Margins>
          <gmr:Scale type="percentage" percentage="100"/>
          <gmr:vcenter value="0"/>
          <gmr:hcenter value="0"/>
          <gmr:grid value="0"/>
          <gmr:even_if_only_styles value="0"/>
          <gmr:monochrome value="0"/>
          <gmr:draft value="0"/>
          <gmr:titles value="0"/>
          <gmr:order>d_then_r</gmr:order>
          <gmr:orientation>portrait</gmr:orientation>
          <gmr:Header Left="" Middle="&amp;[TAB]" Right=""/>
          <gmr:Footer Left="" Middle="Page &amp;[PAGE]" Right=""/>
        </gmr:PrintInformation>
        <gmr:Styles>
          <gmr:StyleRegion startCol="0" startRow="0" endCol="255" endRow="65535">
            <gmr:Style HAlign="1" VAlign="2" WrapText="0" ShrinkToFit="0" Rotation="0" Shade="0" Indent="0" Locked="1" Hidden="0" Fore="0:0:0" Back="FFFF:FFFF:FFFF" PatternColor="0:0:0" Format="General">
              <gmr:Font Unit="10" Bold="0" Italic="0" Underline="0" StrikeThrough="0">Sans</gmr:Font>
              <gmr:StyleBorder>
                <gmr:Top Style="0"/>
                <gmr:Bottom Style="0"/>
                <gmr:Left Style="0"/>
                <gmr:Right Style="0"/>
                <gmr:Diagonal Style="0"/>
                <gmr:Rev-Diagonal Style="0"/>
              </gmr:StyleBorder>
            </gmr:Style>
          </gmr:StyleRegion>
        </gmr:Styles>
        <gmr:Cols DefaultSizePts="48"/>
        <gmr:Rows DefaultSizePts="12.75"/>
        <gmr:Selections CursorCol="0" CursorRow="0">
          <gmr:Selection startCol="0" startRow="0" endCol="0" endRow="0"/>
        </gmr:Selections>
        <gmr:Cells>
          <gmr:Cell Col="0" ValueType="60" Row="0">Date</gmr:Cell>
          <gmr:Cell Col="1" ValueType="60" Row="0">Description</gmr:Cell>
          <gmr:Cell Col="2" ValueType="60" Row="0">Quantity</gmr:Cell>
          <gmr:Cell Col="3" ValueType="60" Row="0">Currency</gmr:Cell>
          <gmr:Cell Col="4" ValueType="60" Row="0">Value</gmr:Cell>
          <gmr:Cell Col="5" ValueType="60" Row="0">Account</gmr:Cell>
          <xsl:apply-templates select="/gnc-v2/gnc:book/gnc:transaction"/>
        </gmr:Cells>
        <gmr:SheetLayout TopLeft="A1"/>
        <gmr:Solver ProblemType="1" Inputs="" MaxTime="0" MaxIter="0" NonNeg="1" Discr="0" AutoScale="0" ShowIter="0" AnswerR="0" SensitivityR="0" LimitsR="0" PerformR="0" ProgramR="0"/>
      </gmr:Sheet>

        <gmr:Sheet DisplayFormulas="0" HideZero="0" HideGrid="0" HideColHeader="0" HideRowHeader="0" DisplayOutlines="1" OutlineSymbolsBelow="1" OutlineSymbolsRight="1">
          <gmr:Name>Commodities</gmr:Name>
          <gmr:MaxCol>-1</gmr:MaxCol>
          <gmr:MaxRow>-1</gmr:MaxRow>
          <gmr:Zoom>1</gmr:Zoom>
          <gmr:PrintInformation>
            <gmr:Margins>
              <gmr:top Points="120" PrefUnit="cm"/>
              <gmr:bottom Points="120" PrefUnit="cm"/>
              <gmr:left Points="0.000000" PrefUnit="Pt"/>
              <gmr:right Points="0.000000" PrefUnit="Pt"/>
              <gmr:header Points="0.000000" PrefUnit="Pt"/>
              <gmr:footer Points="0.000000" PrefUnit="Pt"/>
            </gmr:Margins>
            <gmr:Scale type="percentage" percentage="100"/>
            <gmr:vcenter value="0"/>
            <gmr:hcenter value="0"/>
            <gmr:grid value="0"/>
            <gmr:even_if_only_styles value="0"/>
            <gmr:monochrome value="0"/>
            <gmr:draft value="0"/>
            <gmr:titles value="0"/>
            <gmr:order>d_then_r</gmr:order>
            <gmr:orientation>portrait</gmr:orientation>
            <gmr:Header Left="" Middle="&amp;[TAB]" Right=""/>
            <gmr:Footer Left="" Middle="Page &amp;[PAGE]" Right=""/>
          </gmr:PrintInformation>
          <gmr:Styles>
            <gmr:StyleRegion startCol="0" startRow="0" endCol="255" endRow="65535">
              <gmr:Style HAlign="1" VAlign="2" WrapText="0" ShrinkToFit="0" Rotation="0" Shade="0" Indent="0" Locked="1" Hidden="0" Fore="0:0:0" Back="FFFF:FFFF:FFFF" PatternColor="0:0:0" Format="General">
                <gmr:Font Unit="10" Bold="0" Italic="0" Underline="0" StrikeThrough="0">Sans</gmr:Font>
                <gmr:StyleBorder>
                  <gmr:Top Style="0"/>
                  <gmr:Bottom Style="0"/>
                  <gmr:Left Style="0"/>
                  <gmr:Right Style="0"/>
                  <gmr:Diagonal Style="0"/>
                  <gmr:Rev-Diagonal Style="0"/>
                </gmr:StyleBorder>
              </gmr:Style>
            </gmr:StyleRegion>
          </gmr:Styles>
          <gmr:Cols DefaultSizePts="48"/>
          <gmr:Rows DefaultSizePts="12.75"/>
          <gmr:Selections CursorCol="0" CursorRow="0">
            <gmr:Selection startCol="0" startRow="0" endCol="0" endRow="0"/>
          </gmr:Selections>
          <gmr:Cells>
            <gmr:Cell Col="0" ValueType="60" Row="0">Name</gmr:Cell>
            <gmr:Cell Col="1" ValueType="60" Row="0">Currency</gmr:Cell>
            <gmr:Cell Col="2" ValueType="60" Row="0">Date</gmr:Cell>
            <gmr:Cell Col="3" ValueType="60" Row="0">Value</gmr:Cell>
            <xsl:apply-templates select="/gnc-v2/gnc:book/gnc:pricedb/price"/>
          </gmr:Cells>
          <gmr:SheetLayout TopLeft="A1"/>
          <gmr:Solver ProblemType="1" Inputs="" MaxTime="0" MaxIter="0" NonNeg="1" Discr="0" AutoScale="0" ShowIter="0" AnswerR="0" SensitivityR="0" LimitsR="0" PerformR="0" ProgramR="0"/>
        </gmr:Sheet>

      </gmr:Sheets>
      <gmr:UIData SelectedTab="0"/>
    </gmr:Workbook>

  </xsl:template>

  <!-- output  account information -->
  <xsl:template match="gnc:account">

    <xsl:variable name="id">
      <xsl:value-of select="act:id"/>
    </xsl:variable>

    <gmr:Cell Col="0" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="act:name"/></gmr:Cell>
    <gmr:Cell Col="1" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="act:type"/></gmr:Cell>
    <gmr:Cell Col="2" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="act:code"/></gmr:Cell>
    <xsl:if test="/gnc-v2/gnc:book/gnc:transaction/trn:splits/trn:split[split:account=$id]">
      <gmr:Cell Col="3">
        <xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>
        <xsl:text>=round(</xsl:text>
        <xsl:for-each select="/gnc-v2/gnc:book/gnc:transaction/trn:splits/trn:split[split:account=$id]/split:quantity">
          <xsl:value-of select="."/>
          <xsl:choose>
            <xsl:when test="position()=last()">
              <xsl:text>, 10)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>+</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </gmr:Cell>
      <gmr:Cell Col="4" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="act:commodity/cmdty:id"/></gmr:Cell>
      <gmr:Cell Col="5">
        <xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>
        <xsl:text>=round(</xsl:text>
        <xsl:for-each select="/gnc-v2/gnc:book/gnc:transaction/trn:splits/trn:split[split:account=$id]/split:value">
          <xsl:value-of select="."/>
          <xsl:choose>
            <xsl:when test="position()=last()">
              <xsl:text>, 10)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>+</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </gmr:Cell>
    </xsl:if>

    <!--    <gmr:Cell Col="4"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>=sumif(Transactions!D:D,<xsl:text disable-output-escaping="yes">&amp;</xsl:text>quot;=<xsl:value-of select="act:code"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>quot;,Transactions!C:C)</gmr:Cell>
         -->
    <!--
         <xsl:message>
           id: <xsl:value-of select="act:id"/> 
         code: <xsl:value-of select="(key('accounts',act:id))[1]/act:code"/> 
         value1: <xsl:value-of select="(/gnc-v2/gnc:book/gnc:transaction/trn:splits/trn:split/split:account)[1]"/>   
       </xsl:message>
       -->
     </xsl:template>
     

     <!-- output  transactions information -->

     <xsl:template match="gnc:transaction">

       <xsl:for-each select="trn:splits/trn:split">
         
         <xsl:variable name="code">
           <xsl:value-of select="(key('accounts',split:account))[1]/act:code"/>
         </xsl:variable>
         <xsl:if test="position()=1">
           <gmr:Cell Col="0"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="substring-before(../../trn:date-posted/ts:date,' ')"/></gmr:Cell>
           <gmr:Cell Col="1" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="../../trn:description"/></gmr:Cell>
           <gmr:Cell Col="5">
             <xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>
             <xsl:text>=round(</xsl:text>
             <xsl:for-each select="../trn:split">
               <xsl:value-of select="split:value"/>
               <xsl:choose>
                 <xsl:when test="position()=last()">
                   <xsl:text>, 10)</xsl:text>
                 </xsl:when>
                 <xsl:otherwise>
                   <xsl:text>+</xsl:text>
                 </xsl:otherwise>
               </xsl:choose>
             </xsl:for-each>
           </gmr:Cell>
         </xsl:if>
         <gmr:Cell Col="2"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>=<xsl:value-of select="split:quantity"/></gmr:Cell>
         <gmr:Cell Col="3" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="../../trn:currency/cmdty:id"/></gmr:Cell>
         <gmr:Cell Col="4"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>=<xsl:value-of select="split:value"/></gmr:Cell>
         <gmr:Cell Col="5" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="$code"/></gmr:Cell>
         
       </xsl:for-each>
     </xsl:template>

     <!-- output commodities information -->

     <xsl:template match="price">

       <gmr:Cell Col="0" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="price:commodity/cmdty:id"/></gmr:Cell>
       <gmr:Cell Col="1" ValueType="60"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="price:currency/cmdty:id"/></gmr:Cell>
       <gmr:Cell Col="2"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute><xsl:value-of select="substring-before(price:time/ts:date,' ')"/></gmr:Cell>
       <gmr:Cell Col="3"><xsl:attribute name="Row"><xsl:number level="any"/></xsl:attribute>=<xsl:value-of select="price:value"/></gmr:Cell>
     </xsl:template>

     <xsl:template match="*">
       <xsl:message>Warning: element <xsl:value-of select="name()"/>  not implemented!
     </xsl:message>
   </xsl:template>

 </xsl:stylesheet>
