#!/bin/bash


#---------------------------------------------------------------
# Project         : NeoDoc
# Module          : GnuCash
# File            : cash2numeric.sh
# Author          : Camille Bégnis
# Created On      : 2005-07-01
# Copyright       : Camille Bégnis <camille@neodoc.biz>,
#                    NeoDoc under the GPL license
#---------------------------------------------------------------

# This script takes a gnucash XML file (uncompressed) and outputs a
# gnumeric compatible calc sheet.

# usage: cash2numeric.sh Accounts.gnucash

input=$1
tmp=/tmp/$(basename $input).tmp
output=$(basename $input .gnucash).gnumeric
xsl=gnumeric.xsl

namespaces="xmlns:cd='cd' xmlns:gnc='gnc' xmlns:book='book' xmlns:slot='slot' xmlns:cmdty='cmdty' xmlns:price='price' xmlns:ts='ts' xmlns:act='act' xmlns:lot='lot' xmlns:trn='trn' xmlns:split='split' xmlns:sx='sx' xmlns:fs='fs' xmlns:cust='cust' xmlns:addr='addr' xmlns:job='job' xmlns:taxtable='taxtable' xmlns:tte='tte' xmlns:owner='owner' xmlns:invoice='invoice' xmlns:entry='entry' xmlns:vendor='vendor'"

sed -e "s/<gnc-v2>/\<gnc-v2 $namespaces\>/" $input > $tmp

echo transforming $input into $output...

xsltproc -o $output $xsl $tmp

rm -f $tmp